#include <stdlib.h>
#include "main.h"
#include "stdio.h"
#include "utility.h"
#include "modelManager.h"
#include "texManager.h"
#include "motionManager.h"
#include "sceneModel.h"

// ======== ======== ======== ======== ======== ======== ======== ========
// ÓIoϐ
// -------- -------- -------- -------- -------- -------- -------- --------
std::unordered_map<std::string, CMotionManager*> CMotionManager::m_umapMotionManager;	// [V}l[W

int CMotionManager::m_fileSize = 0;				// t@C
int CMotionManager::m_currentSrc = 0;			// ݈ʒu
char *CMotionManager::m_pSrcData = nullptr;		// i[p|C^
char CMotionManager::m_buf[MAX_PATH] = {""};	// obt@(ꎞi[p)

// ======== ======== ======== ======== ======== ======== ======== ========
// [Vǂݍ
// -------- -------- -------- -------- -------- -------- -------- --------
void CMotionManager::LoadMotion(const std::string &strFilePass)
{
	assert(!strFilePass.empty() && "[Ṽt@CpXsł");

	// vf̗Lm߂
	if (m_umapMotionManager.count(strFilePass) == 1)
	{// ܂
		return;
	}

	// 
	m_fileSize = 0;			// t@C
	m_currentSrc = 0;		// ݈ʒu	
	m_pSrcData = nullptr;	// i[p|C^

	// t@Cǂݍ
	FILE *pFile;			// t@C|C^
	pFile = fopen(&strFilePass[0], "r");
	// nullptr`FbN
	if (pFile == nullptr) {
		assert(!"[Ṽt@CpXǂݍ߂܂ł");
	}

	// [V}l[W̎̂̐
	CMotionManager *pMotManager = new CMotionManager;

	fseek(pFile, 0, SEEK_END);			// 
	m_fileSize = ftell(pFile);			// 
	fseek(pFile, 0, SEEK_SET);			// t@CTCY擾

	m_pSrcData = (char *)malloc(m_fileSize);	// ǂݍ݃obt@[m

	fread(m_pSrcData, m_fileSize, 1, pFile);	// t@Cǂݍ
	fclose(pFile);								// t@C

	// XNvgǂݍ݊Jn
	seekSrcData("SCRIPT");
	if (m_currentSrc >= m_fileSize)
	{
		free(m_pSrcData);
		assert(!"XNvg̒g[SCRIPT]܂");
	}

	//========================================
	// f̎擾
	//========================================
	seekSrcData("NUM_MODEL = ");
	pMotManager->m_numModel = getNumInt();

	//========================================
	// ft@C̎擾
	//========================================
	pMotManager->m_vecModel.resize(pMotManager->m_numModel);
	CSceneModel *pModel;
	for (int i = 0; i < pMotManager->m_numModel; i++)
	{
		seekSrcData("MODEL_FILENAME = ");
		pModel = new CSceneModel();
		pModel->SetFilePass(getChar());
		pMotManager->m_vecModel.push_back(pModel);
	}

	//========================================
	// LN^[
	//========================================
	// ړ
	seekSrcData("MOVE = ");
	pMotManager->m_chara.move = getNumFloat();
	// Wv
	seekSrcData("JUMP = ");
	pMotManager->m_chara.jump = getNumFloat();
	// 蔻̔a
	seekSrcData("RADIUS = ");
	pMotManager->m_chara.rad = getNumFloat();
	// p[c
	seekSrcData("NUM_PARTS = ");
	pMotManager->m_chara.numParts = getNumInt();

	//========================================
	// p[c̓ǂݎ
	//========================================
	float x, y, z;
	std::vector<PARTS> vecParts;
	PARTS parts;
	vecParts.resize(pMotManager->m_numModel);

	for (int i = 0; i < pMotManager->m_chara.numParts; i++)
	{
		// CfbNX
		seekSrcData("m_index = ");
		parts.index = getNumInt();
		// ẽCfbNX
		seekSrcData("PARENT = ");
		parts.parent = getNumInt();
		// W
		seekSrcData("POS = ");
		x = getNumFloat();
		y = getNumFloat();
		z = getNumFloat();
		pMotManager->m_vecModel[i]->SetPos(D3DXVECTOR3(x, y, z));
		pMotManager->m_vecModel[i]->SetBasePos(D3DXVECTOR3(x, y, z));
		// px
		seekSrcData("ROT = ");
		x = getNumFloat();
		y = getNumFloat();
		z = getNumFloat();
		pMotManager->m_vecModel[i]->SetRot(D3DXVECTOR3(x, y, z));
		pMotManager->m_vecModel[i]->SetBaseRot(D3DXVECTOR3(x, y, z));
	}

	// ep[c̃t@CpX𒲂ׂ
	int i = 0;
	int j = 0;
	for (auto it : pMotManager->m_vecModel)
	{
		j = 0;
		for (auto itParent : pMotManager->m_vecModel)
		{
			if (vecParts[i].parent == vecParts[j].index)
			{
				// p[cɐẽ|C^ݒ
				it->SetParent(CSceneModel::GetParts(itParent->GetFilePath()));
			}
			else if (vecParts[i].parent == -1)
			{
				// p[c̐enull
				it->SetParent(nullptr);
			}
			j++;
		}
		i++;
	}

	//========================================
	// [V
	//========================================
	int motionIndex = 0;
	bool bMotion = false;
	MOTION *pMotion;		// [V
	// [V[v
	while (1)
	{
		// ܂ōs烋[v𔲂
		if (strcmp(&m_pSrcData[m_currentSrc], "END_SCRIPT") == 0 || m_currentSrc >= m_fileSize)
		{
			break;
		}
		if (bMotion == true)
		{
			seekSrcData("END_MOTIONSET");
			bMotion = false;
		}
		// [V
		if (seekSrcData("MOTIONSET"))
		{
			bMotion = true;

			// -------- -------- -------- --------
			// [V̐
			// -------- -------- -------- --------
			pMotion = new MOTION;
			// [V̏
			pMotion->index = 0;
			pMotion->numKey = 0;
			pMotion->loop = false;

			pMotion->index = motionIndex;	// CfbNX̐ݒ
		}
		else
		{
			break;
		}

		// [v邩ǂ
		seekSrcData("LOOP = ");
		pMotion->loop = (bool)getNumInt();
		// L[̐
		seekSrcData("NUM_KEY = ");
		pMotion->numKey = getNumInt();

		// -------- -------- -------- --------
		// L[̐錾
		// -------- -------- -------- --------
		KEY *pKey = new KEY;
		// L[̏
		pKey->flame = 0;
		pKey->index = 0;

		// L[[v
		for (int cntKey = 0, end = pMotion->numKey; cntKey < end; cntKey++)
		{
			// ړt[
			seekSrcData("FRAME = ");
			pKey->flame = getNumInt();
			pKey->index = cntKey;			// CfbNX̎擾

			// -------- -------- -------- --------
			// [up[c̐錾
			// -------- -------- -------- --------
			MOVEPARTS *pMoveParts = new MOVEPARTS;
			// [up[c̏
			pMoveParts->index = 0;
			pMoveParts->pos = D3DXVECTOR3(0.f, 0.f, 0.f);
			pMoveParts->rot = D3DXVECTOR3(0.f, 0.f, 0.f);
			pMoveParts->posParFlame = D3DXVECTOR3(0.f, 0.f, 0.f);
			pMoveParts->rotParFlame = D3DXVECTOR3(0.f, 0.f, 0.f);

			// p[c[v
			for (int cntParts = 0, numParts = pMotManager->m_chara.numParts; cntParts < numParts; cntParts++)
			{
				pMoveParts->index = cntParts;		// CfbNX̐ݒ

				// W
				seekSrcData("POS = ");
				pMoveParts->pos = D3DXVECTOR3(getNumFloat(), getNumFloat(), getNumFloat());
				// px
				seekSrcData("ROT = ");
				pMoveParts->rot = D3DXVECTOR3(getNumFloat(), getNumFloat(), getNumFloat());
				seekSrcData("END_KEY");

				// t[̈ړʂ̏
				pMoveParts->posParFlame = D3DXVECTOR3(0.f, 0.f, 0.f);
				pMoveParts->rotParFlame = D3DXVECTOR3(0.f, 0.f, 0.f);

				// [up[cvbVobN
				pKey->lisMoveParts.push_back(pMoveParts);
			}
			seekSrcData("END_KEYSET");

			// L[vbVobN
			pMotion->lisKey.push_back(pKey);
		}

		// [VvbVobN
		pMotManager->m_lisMotion.push_back(pMotion);
		motionIndex++;	// CfbNXi߂
	}

	// [V̏}l[Wɓ
	m_umapMotionManager[strFilePass] = pMotManager;

	// obt@
	free(m_pSrcData);
}

// ======== ======== ======== ======== ======== ======== ======== ========
// ̎̕܂Ői߂
// -------- -------- -------- -------- -------- -------- -------- --------
bool CMotionManager::seekSrcData(char *texName)
{
	for (int i = 0; i < MAX_PATH; i++) { m_buf[i] = '\0'; }
	strcat(m_buf, texName);
	int len = strlen(&m_buf[0]);
	while (1)
	{
		if (strncmp(&m_pSrcData[m_currentSrc], m_buf, len) == 0)
		{
			m_currentSrc += len;// - 1;
			return true;
		}
		else
		{
			m_currentSrc++;
		}
		if (m_currentSrc >= m_fileSize) { break; }
	}
	return false;
}

// ======== ======== ======== ======== ======== ======== ======== ========
// int^Ŏ擾()
// -------- -------- -------- -------- -------- -------- -------- --------
int CMotionManager::getNumInt(void)
{
	int numVtx = 0;		// 
	for (int i = 0; i < MAX_PATH; i++) { m_buf[i] = '\0'; }
	while (1)
	{
		// 󔒑Ol̂߁A󔒂܂Ń[v
		if (m_pSrcData[m_currentSrc] == 32 || m_pSrcData[m_currentSrc] == 10 || m_pSrcData[m_currentSrc] == 9)
		{
			numVtx = atoi(m_buf);		// _̑̎擾
			m_currentSrc++;
			return numVtx;
		}
		else
		{//  or . or - ȊO͖
			if (m_pSrcData[m_currentSrc] >= 48 && m_pSrcData[m_currentSrc] < 57 || m_pSrcData[m_currentSrc] == 46 || m_pSrcData[m_currentSrc] == 45)
			{
				// ̘A
				strncat(&m_buf[0], &m_pSrcData[m_currentSrc], 1);
			}
			m_currentSrc++;
		}
	}
	return numVtx;
}

// ======== ======== ======== ======== ======== ======== ======== ========
// float^Ŏ擾()
// -------- -------- -------- -------- -------- -------- -------- --------
float CMotionManager::getNumFloat(void)
{
	float numVtx = 0.f;	// 
	for (int i = 0; i < MAX_PATH; i++) { m_buf[i] = '\0'; }
	while (1)
	{
		// 󔒑Ol̂߁A󔒂܂Ń[v
		if (m_pSrcData[m_currentSrc] == 32 || m_pSrcData[m_currentSrc] == 10 || m_pSrcData[m_currentSrc] == 9)
		{
			numVtx = static_cast<float>(atof(m_buf));		// _̑̎擾
			m_currentSrc++;
			return numVtx;
		}
		else
		{//  or . or - ȊO͖
			if (m_pSrcData[m_currentSrc] >= 48 && m_pSrcData[m_currentSrc] < 57 || m_pSrcData[m_currentSrc] == 46 || m_pSrcData[m_currentSrc] == 45)
			{
				// ̘A
				strncat(&m_buf[0], &m_pSrcData[m_currentSrc], 1);
			}
			m_currentSrc++;
		}
	}
	return numVtx;
}

// ======== ======== ======== ======== ======== ======== ======== ========
// char^Ŏ擾()
// -------- -------- -------- -------- -------- -------- -------- --------
char *CMotionManager::getChar(void)
{
	for (int i = 0; i < MAX_PATH; i++) { m_buf[i] = '\0'; }
	while (1)
	{
		// 󔒑Ol̂߁A󔒂܂Ń[v
		if (m_pSrcData[m_currentSrc] == 32 || m_pSrcData[m_currentSrc] == 10 || m_pSrcData[m_currentSrc] == 9)
		{
			m_currentSrc++;
			return &m_buf[0];
		}
		else
		{
			// ̘A
			strncat(&m_buf[0], &m_pSrcData[m_currentSrc], 1);
			m_currentSrc++;
		}

		if (strncmp(&m_pSrcData[m_currentSrc], "#", 1) == 0)
		{
			return nullptr;
		}
	}
	return &m_buf[0];
}

// ======== ======== ======== ======== ======== ======== ======== ========
// [VS
// -------- -------- -------- -------- -------- -------- -------- --------
void CMotionManager::ReleaseAll(void)
{
	// Rei𖖔܂Ń[v
	for (auto it : m_umapMotionManager)
	{
		// [V
		if (it.second != nullptr)
		{
			if (it.second->m_pSrcData != nullptr)
			{
				delete it.second->m_pSrcData;
				it.second->m_pSrcData = nullptr;
			}
			if (it.second != nullptr)
			{
				delete it.second;
				it.second = nullptr;
			}
		}
	}
	m_umapMotionManager.clear();
}

// [V}l[W
CMotionManager *CMotionManager::GetMotionManager(std::string strName)
{
	if (m_umapMotionManager.count(strName) >= 1)
	{
		return m_umapMotionManager[strName];
	}
	assert(!"̃[V̎w肪ԈĂ܂");
	return nullptr;
}

// [V
CMotionManager::MOTION *CMotionManager::GetMotion(int index)
{
	for (auto pMotion : m_lisMotion) 
	{
		if (pMotion->index == index) { return pMotion; }
	}
	assert(!"̃CfbNX̎w肪ԈĂ܂");
	return nullptr;
}

// L[
CMotionManager::KEY *CMotionManager::GetKeyList(MOTION *pMotion, int index)
{
	for (auto pKey : pMotion->lisKey)
	{
		if (pKey->index == index) { return pKey; }
	}
	assert(!"̃CfbNX̎w肪ԈĂ܂");
	return nullptr;
}

// pMoveParts
CMotionManager::MOVEPARTS *CMotionManager::GetMovePartsList(KEY *pKey, int index)
{
	for (auto pMoveParts : pKey->lisMoveParts)
	{
		if (pMoveParts->index == index) { return pMoveParts; }
	}
	assert(!"̃CfbNX̎w肪ԈĂ܂");
	return nullptr;
}